//
//	Class definition for Message Box Dialog class
//

#ifndef THE_MESSAGE_BOX_DIALOG_H
#define THE_MESSAGE_BOX_DIALOG_H

#include "../Utils/theStringManager.h"
#include "ldwTiledDialog.h"

enum EMessageBoxType
{
	eMessageBoxOk,
	eMessageBoxOkCancel,
	eMessageBoxYesNo
};

class ldwImageGrid;

class theMessageBoxDlg : public ldwTiledDialog
{
public:

	theMessageBoxDlg(StringId messageId,int dlgCanvas,EMessageBoxType mbType);
	theMessageBoxDlg(StringId messageId,int dlgCanvas,bool hasCancel = false);
	theMessageBoxDlg(const char *message,int dlgCanvas,bool hasCancel = false);

	~theMessageBoxDlg();

	int  GetResult();

	bool HandleKey(int messageId,int keyCode,int character);
	bool HandleMessage(int messageId,long data);

protected:

	enum {eOkButtonId = 1, eCancelButtonId};

	void DrawNoFadeScene();

	void Init(const char *message,int dlgCanvas,EMessageBoxType mbType);

	int  mResult;
};

#endif
